/**
 * Copyright: Codetipi
 * Plugin: Lets Review
 * Version: 3.4.3
 */
(function($) { 'use strict';

	var $window = $( window );

	tinymce.create( 'tinymce.plugins.lets_review_buttons', {

		init: function( editor, url )  {

			editor.addButton('lets_review_buttons', {
			    tooltip      : editor.getLang( 'letsReview.mainTitle' ),
		        icon         : '-codetipi tipi-icon tipi-i-lets-review',
		        type         : 'menubutton',
		        menu         : [
		        	{
		        		text: editor.getLang( 'letsReview.existingreview' ),
		        		onclick: function() { editor.execCommand( 'plugin_command', true, 1 ); }
		        	},
		        	{
		        		text: editor.getLang( 'letsReview.uniquereview' ),
		        		onclick: function() { editor.execCommand( 'plugin_command', true, 2 ); }
		        	},
		        	{
		        		text: editor.getLang( 'letsReview.affiliate' ),
		        		onclick: function() { editor.execCommand( 'plugin_command', true, 3 ); }
		        	},
		        	{
		        		text: editor.getLang( 'letsReview.list' ),
		        		onclick: function() { editor.execCommand( 'plugin_command', true, 4 ); }
		        	},
		        	{
		        		text: editor.getLang( 'letsReview.userrating' ),
		        		onclick: function() { editor.execCommand( 'plugin_command', true, 5 ); }
		        	},
		        ]
			});

			editor.addCommand( 'plugin_command', function( a, b ) {

				editor.windowManager.open({
					title: editor.getLang( 'letsReview.mainTitle' ),
					id: 'lets-review-insert-dialog',
					width: $window.width() * 0.8,
					height: ( $window.height() - 85 ) * 0.8,
					autoScroll: true,
					resizable: true,
					buttons: [{
						text: editor.getLang( 'letsReview.insert' ),
						id: 'lets-review-button-insert',
						onclick: function( e ) {
							var insert = lets_review_insert( b );
							editor.insertContent( insert );
							editor.windowManager.windows[0].close();
						},
					}, {
						text: editor.getLang( 'letsReview.close' ),
						id: 'lets-review-cancel',
						onclick: 'close'
					}],
				});

				lets_review_box( b, editor );

			});

		}

	});

	tinymce.PluginManager.add( 'lets_review_buttons', tinymce.plugins.lets_review_buttons );

	function lets_review_box( component, ed ) {

		var dialog = $( '#lets-review-insert-dialog-body' );
		dialog.append( '<div class="tipi-spinner-wrap"><i class="tipi-icon tipi-i-rotate-left"></i></div>' );

		$.post( ajaxurl, {
			action: 	'lets_review_buttons_insert_dialog',
			component: 	component
		}, function( data ) {
			if (  data.charAt( data.length - 1) === '0' ) {
				data = data.slice(0, -1);
			}
			dialog.append( data );
			$( '.tipi-spinner-wrap' ).hide();
			$( '#mce-modal-block' ).on( 'click', function(){
				ed.windowManager.windows[0].close();
			});
			$('.lets-review-colorpicker').wpColorPicker();
			$('.cb-f-score-modal').slider({
				min: 0,
				max: 100,
				range: 'min',
				step: 1,
			});
			lets_review_runner();
		});

	}

	function lets_review_runner() {

		$('#lets-review-insert-dialog-body').find( '.ui-sortable' ).sortable({
		  	placeholder: "ui-state-highlight",
			classes: {
				"ui-sortable": "lets-review-control-only"
			}
		});

		var wrapper = $('.lets-review-box-wrap');
		var blocks = wrapper.find('.block');

		blocks.each(function() {
			var thisBlock = $(this);
			var thisBlockData = thisBlock.data();

			if ( thisBlockData['req'] !== '' ) {
				var dependee = $( '#' + thisBlockData['req'] );
				if ( dependee.hasClass( 'block-radioimages' ) ) {
					$('input[type=radio][name=' + thisBlockData['req'] + ']').change(function( e ) {
						var array;
						var reqValue = thisBlockData['reqValue'];

						if ( (/,/i.test(reqValue)) ) {
							array = reqValue.split(',');
						} else {
							array = [ reqValue.toString() ];
						}

						if ( array.includes( $(this).val().toString() ) ) {
							thisBlock.slideDown( 200 );
						} else {
							thisBlock.slideUp( 200 );
						}
					});
				}

				if ( dependee.hasClass( 'block-select' ) ) {
					$('.column-' + thisBlockData['req'] ).change(function( e ) {
						var array;
						var reqValue = thisBlockData['reqValue'];
						if ( (/,/i.test(reqValue)) ) {
							array = reqValue.split(',');
						} else {
							array = [ reqValue.toString() ];
						}

						if ( array.includes( $(this).val().toString() ) ) {
							thisBlock.slideDown( 200 );
						} else {
							thisBlock.slideUp( 200 );
						}
					});
				}

			}

		});
	}

	function lets_review_insert( b ) {

		var output, $body = $('#lets-review-insert-dialog-body');

		switch (b) {
		    case 2:
		        output = '[letsreviewunique';

		        if ( $body.find('.column-title').val().length ) {
		    		output += ' title="' + $body.find('.column-title').val() + '"';
		    	}

		    	if ( $body.find('.column-subtitle').val().length ) {
		    		output += ' score_subtitle="' + $body.find('.column-subtitle').val() + '"';
		    	}

		    	if ( $body.find('.column-conclusion-title').val().length ) {
		    		output += ' conclusion_title="' + $body.find('.column-conclusion-title').val() + '"';
		    	}

		    	if ( $body.find('.column-affiliate-title').val().length ) {
		    		output += ' affiliate_title="' + $body.find('.column-affiliate-title').val() + '"';
		    	}

		    	if ( $body.find('.column-prostitle').val().length ) {
		    		output += ' pros_title="' + $body.find('.column-prostitle').val() + '"';
		    	}

		    	var proDetect = $body.find('.cb-pro-detect');

		    	if ( proDetect.length > 0 ) {
			    	output += ' pros="';
			    	if ( proDetect.length === 1 ) {
			    		output += proDetect.val();
			    	} else {
			    		var i = 1;
			    		proDetect.each(function() {
			    			output += $(this).val();
			    			if ( i !== proDetect.length ) {
			    				output += ',';
			    			}
			    			i++;
			    		});
			    	}
		    		output += '"';
		    	}
		    	
		    	if ( $body.find('.column-constitle').val().length ) {
		    		output += ' cons_title="' + $body.find('.column-constitle').val() + '"';
		    	}

		    	var conDetect = $body.find('.cb-con-detect');

		    	if ( conDetect.length > 0 ) {
			    	output += ' cons="';
			    	if ( conDetect.length === 1 ) {
			    		output += conDetect.val();
			    	} else {
			    		var n = 1;
			    		conDetect.each(function() {
			    			output += $(this).val();
			    			if ( n !== conDetect.length ) {
			    				output += ',';
			    			}
			    			n++;
			    		});
			    	}
		    		output += '"';
		    	}

		    	var critDetect = $body.find('.cb-crit-detect');

		    	if ( critDetect.length > 0 ) {
			    	output += ' criterias="';
			    	if ( critDetect.length === 1 ) {
			    		output += critDetect.val();
			    	} else {
			    		var n = 1;
			    		critDetect.each(function() {
			    			output += $(this).val();
			    			if ( n !== critDetect.length ) {
			    				output += ',';
			    			}
			    			n++;
			    		});
			    	}
		    		output += '"';
		    	}

		    	var affDetect = $body.find('.cb-aff-detect');

		    	if ( affDetect.length > 0 ) {
			    	output += ' affiliate="';
			    	if ( affDetect.length === 1 ) {
			    		output += affDetect.val();
			    	} else {
			    		var n = 1;
			    		affDetect.each(function() {
			    			output += $(this).val();
			    			if ( n !== affDetect.length ) {
			    				output += ',';
			    			}
			    			n++;
			    		});
			    	}
		    		output += '"';
		    	}

		    	if ( $body.find('.column-gallery-title').val().length ) {
		    		output += ' gallery-title="' + $body.find('.column-gallery-title').val() + '"';
		    	}

		    	var galleryDetect = $body.find('.cb-gallery-detect');

		    	if ( galleryDetect.length > 0 ) {
			    	output += ' gallery="';
			    	if ( galleryDetect.length === 1 ) {
			    		output += galleryDetect.val();
			    	} else {
			    		var n = 1;
			    		galleryDetect.each(function() {
			    			output += $(this).val();
			    			if ( n !== galleryDetect.length ) {
			    				output += ',';
			    			}
			    			n++;
			    		});
			    	}
		    		output += '"';
		    	}

		    	if ( $body.find('.column-accent-color').val().length ) {
		    		output += ' accent="' + $body.find('.column-accent-color').val() + '"';
		    	}

		    	output += ' final_score="' + $body.find('.column-final-score').val() + '"';
		    	
		    	output += ' format="' + $body.find('.column-format input[name=format]:checked').val() + '"';

		    	output += ' skin="' + $body.find('.column-skin input[name=skin]:checked').val() + '"';

		    	output += ' animation="' + $body.find('.column-animation input[name=animation]:checked').val() + '"';

		    	output += ' design="' + $body.find('.column-design input[name=design]:checked').val() + '"';

		    	if ( $body.find('#custom-img-modal .cb-gallery-img').length ) {
		    		output += ' custom_image="' + $body.find('#custom-img-modal .cb-gallery-img').data( 'cb-id' ) + '"';
		    	}

		    	if ( $body.find( '.column-custom_icon_code').val().length ) {
		    		output += ' icon_code="' + sanitizeIt( $body.find('.column-custom_icon_code').val() ) + '"';
		    	}

		    	if ( $body.find('#img-modal .cb-gallery-img').length ) {
		    		output += ' main_image="' + $body.find('#img-modal .cb-gallery-img').data( 'cb-id' ) + '"';
		    	}


		    	output += ']';

		    	if ( $body.find('.column-conclusion').val().length ) {
		    		output += $body.find('.column-conclusion').val();
		    	}

		    	output += '[/letsreviewunique]';
		        break;
		    case 3:
		        output = '[letsreviewaffiliate ';
		    	output += ' url="' + $body.find('.column-url').val() + '"';
		    	output += ' text="' + $body.find('.column-title').val() + '"';
		    	output += ' size="' + $body.find('.column-size').val() + '"';
		    	output += ' rel="' + $body.find('.column-rel').val() + '"';
		    	output += ' target="' + $body.find('.column-target').val() + '"';
		    	output += ' accent="' + $body.find('.column-color').val() + '"';
		    	if ( $body.find('.column-alignment').val() === 'center' ) {
		    		output += ' textalign="center"';
		    	}
		    	output += ' border="' + $body.find('.column-border').val() + '"';
		    	output += ']';


		        break;
		    case 4:
		        output = '[letsreviewlist';
		        output += ' title="' + $body.find('.column-title').val() + '"';
		        
		    	output += ' design="' + $body.find('.column-style').val() + '"';
		    	output += ' order="' + $body.find('.column-order').val() + '"';
		    	output += ' source="' + $body.find('.column-source').val() + '"';
		    	output += ' type="' + $body.find('.column-type').val() + '"';

		    	if ( parseInt( $body.find('.column-source').val() ) === 1 ) {
		    		output += ' postid="';
			        if ( $body.find('.column-pids').val().length ) {
				    	output += $body.find('.column-pids').val();
				    }
				    output += '"';
		    	} else if ( parseInt( $body.find('.column-source').val() ) === 2 ) {

		    		output += ' cats="';
			        if ( $body.find('.column-cats').val().length ) {
				    	output += $body.find('.column-cats').val();
				    }
				    output += '"';
				    output += ' ppp="';
				    if ( $body.find('.column-numberposts').val().length ) {
				    	output += $body.find('.column-numberposts').val();
				    }
				    output += '"';

		    	} else if ( parseInt( $body.find('.column-source').val() ) === 3 ) {
		    		output += ' tags="';
			        if ( $body.find('.column-tags').val().length ) {
				    	output += $body.find('.column-tags').val();
				    }
				    output += '"';

				    output += ' ppp="';
				    if ( $body.find('.column-numberposts').val().length ) {
				    	output += $body.find('.column-numberposts').val();
				    }
				    output += '"';
		    	}

		    	output += ' proscons="' + $body.find('.column-prosconsonoff').val() + '"';
		    	output += ']';


		        break;
		    case 5:
		        output = '[letsreviewuserrating';
		        	output += ' postid="' + $('#post_ID').val() + '"';
		        	output += ' id="' + $body.find('.column-id').val() + '"';

		        	if ( $body.find('.column-title').val().length ) {
				    	output += ' title="' + $body.find('.column-title').val() + '"';
				    }
				    
				    if ( $body.find('.column-content-title').val().length ) {
				    	output += ' content_title="' + $body.find('.column-content-title').val() + '"';
				    }
				    if ( $body.find('#custom-img-modal .cb-gallery-img').length ) {
			    		output += ' custom_image="' + $body.find('#custom-img-modal .cb-gallery-img').data( 'cb-id' ) + '"';
			    	}

			    	if ( $body.find('#user-img-modal .cb-gallery-img').length ) {
			    		output += ' image="' + $body.find('#user-img-modal .cb-gallery-img').data( 'cb-id' ) + '"';
			    	}

			    	if ( $body.find( '.column-custom_icon_code').val().length ) {
			    		output += ' icon_code="' + $body.find('.column-custom_icon_code').val() + '"';
			    	}

			    	output += ' format="' + $body.find('.column-format input[name=format]:checked').val() + '"';

		    		output += ' design="' + $body.find('.column-design input[name=design]:checked').val() + '"';

		        	// TIPITEMP: Is background neeed? output += ' background="' + $body.find('.column-color').val() + '"';
		        	output += ' score_box="' + $body.find('.column-scorebox').val() + '"';
			    	output += ' skin="' + $body.find('.column-skin input[name=skin]:checked').val() + '"';
		        	
		        output += ']';

		        if ( $body.find('.column-content').val().length ) {
			    	output += $body.find('.column-content').val();
			    }

				output += '[/letsreviewuserrating]';

		        break;
		    default:
		    	output = '[letsreview';
		    	output += ' postid="' + $body.find('.column-pid').val() + '"';
		    	output += ']';
		        break;
		}
		return output;

	}

	function sanitizeIt( string ) {
	   return string.replace(/&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
	}

})(jQuery);